require( "scripts/style.lua" );

require( "scripts/basicSetting.lua");

guestCreationDelay = 38000;
guestCreationSpeedIncrease = 2500;
minGuestsToCreate = 3;
maxGuestsToCreate = 5;

useFloAsServer = 0;
useWineTable = 1;
numMoodBoosts = 3;


levelSetting1 = 
{	
	-- total of 100%
	guestListPercentage = 
	{
		female01Percent=10,
		female02Percent=10,
		female03Percent=10,
		female04Percent=10,
		male01Percent=10,
		male02Percent=10,
		male03Percent=10,
		male04Percent=10,
		unclePercent=10,
		auntPercent=10
	},
	
	guestAttributes = 
	{
	-- low to high range
	-- percentage from 0 to 100
		tolerance =		{50000, 60000},
		waitBeforeSit =		{1000, 1000},
		waitBeforeAppetizer =	{1000, 1000},
		waitBeforeDinner =	{8000, 8000},
		waitBeforeCake =	{12000, 12000},
		waitBeforeGift =	{1000, 1000},
		percentRequestDrink =	{0, 10},
		percentRequestMusic =	{0, 10},
		percentRequestResit =	{0, 10},
		percentRequestCoffee =	{10, 50},
		percentRequestTissue =	{10, 50}
	}
}




dofile("scripts/LevelManager.lua");

LManager = LevelManager.create();
LManager:SetLevelNumber(4,1);

LManager:AddNewTable( 1, 4, 180, 360, "assets/images/table/redtable", "assets/images/food/item_mark1", "R" );
LManager:AddNewTable( 2, 2, 390, 360, "assets/images/table/redtable_2", "assets/images/food/item_mark2", "R" );
LManager:AddNewTable( 3, 4, 260, 485, "assets/images/table/bluetable", "assets/images/food/item_mark3", "B" );
LManager:AddNewTable( 4, 4, 260, 230, "assets/images/table/bluetable", "assets/images/food/item_mark4", "B" );

LManager:SetLevelSetting ("dogDelay", 400000);
LManager:SetLevelSetting ("dogChance", 100);

LManager:SetLevelSetting ("cakeTipDelay", 300000);
LManager:SetLevelSetting ("cakeTipChance", 100);

LManager:SetLevelSetting ("speakerDelay", 500000);
LManager:SetLevelSetting ("speakerChance", 60);

LManager:SetLevelSetting ("blaster", 1);

-- Testing...
LManager:SetLevelSetting( "guestLeaveAllow", 5 );

gameObject = LManager:GenerateGameObject();

levelSetting = LManager:GenerateLevelSettings();
levelSetting.mode = "endless";
levelSetting.passScore = 
	{
	    700 -- the base score. for each level the passScore is baseScore + baseScore*level*level
	};
	
--dofile( "scripts/LevelDialogGenerator.lua" );

LManager:SetChairImage("assets/images/table/chair04");

MakeDialog
{

	Bitmap
	{
		name="backgroundimage",
		image="images/bg_island",
				
		GameWindow
		{ 	
			x = 0, y = 0, w = kMax, h = kMax,
			Button{
			x=800, y=600, --set offscreen
			--x=140,
			--y=550,
			font = StandardButtonFont,
			graphics = StandardButtonGraphics,
			name="upgrade",
			label="upgradetitle",
			type = kPush,
			command = 
				function()
				    OpenArcadeUpgrade();
				end
				
			};			
		},
		-- the pause button
		Button{
			x=10,
			y=550,
			font = StandardButtonFont,
			graphics = StandardButtonGraphics,
			name="pause",
			label="ui.dialog.pause.title",
			type = kPush,
			command = 
				function()
				    DoPause();
				end
				
		};
	},
	
}
